/**
 * Admin panel JavaScript
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        // Confirm appointment
        $(document).on('click', '.appointment-confirm', function() {
            const id = $(this).data('id');
            const $row = $(this).closest('tr');
            
            if (confirm('Bu randevuyu onaylamak istediğinizden emin misiniz?')) {
                updateStatus(id, 'confirmed', $row);
            }
        });
        
        // Reject appointment
        $(document).on('click', '.appointment-reject', function() {
            const id = $(this).data('id');
            const $row = $(this).closest('tr');
            
            if (confirm('Bu randevuyu reddetmek istediğinizden emin misiniz?')) {
                updateStatus(id, 'rejected', $row);
            }
        });
        
        // Delete appointment
        $(document).on('click', '.appointment-delete', function() {
            const id = $(this).data('id');
            const $row = $(this).closest('tr');
            
            if (confirm('Bu randevuyu silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.')) {
                deleteAppointment(id, $row);
            }
        });
        
        function updateStatus(id, status, $row) {
            $.ajax({
                url: appointmentAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'appointment_admin_update_status',
                    nonce: appointmentAdmin.nonce,
                    id: id,
                    status: status
                },
                success: function(response) {
                    if (response.success) {
                        // Update status badge
                        const statusLabels = {
                            'pending': 'Bekleyen',
                            'confirmed': 'Onaylanan',
                            'rejected': 'Reddedilen',
                            'cancelled': 'İptal'
                        };
                        
                        $row.find('.status-badge')
                            .removeClass('status-pending status-confirmed status-rejected status-cancelled')
                            .addClass('status-' + status)
                            .text(statusLabels[status]);
                        
                        // Remove action buttons for confirm/reject
                        $row.find('.appointment-confirm, .appointment-reject').remove();
                        
                        // Show success message
                        showNotice('Durum güncellendi.', 'success');
                    } else {
                        showNotice('Güncelleme başarısız.', 'error');
                    }
                },
                error: function() {
                    showNotice('Bir hata oluştu.', 'error');
                }
            });
        }
        
        function deleteAppointment(id, $row) {
            $.ajax({
                url: appointmentAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'appointment_admin_delete',
                    nonce: appointmentAdmin.nonce,
                    id: id
                },
                success: function(response) {
                    if (response.success) {
                        $row.fadeOut(300, function() {
                            $(this).remove();
                        });
                        showNotice('Randevu silindi.', 'success');
                    } else {
                        showNotice('Silme başarısız.', 'error');
                    }
                },
                error: function() {
                    showNotice('Bir hata oluştu.', 'error');
                }
            });
        }
        
        function showNotice(message, type) {
            // Remove existing notices
            $('.admin-notice.dynamic').remove();
            
            const iconMap = {
                'success': 'yes-alt',
                'error': 'warning',
                'warning': 'info',
                'info': 'info-outline'
            };
            
            const $notice = $('<div class="admin-notice dynamic ' + type + '">' +
                '<span class="dashicons dashicons-' + iconMap[type] + '"></span>' +
                '<span>' + message + '</span>' +
            '</div>');
            
            $('.admin-page-header').after($notice);
            
            setTimeout(function() {
                $notice.fadeOut(300, function() {
                    $(this).remove();
                });
            }, 3000);
        }
        
        // Copy shortcode functionality
        $(document).on('click', '.copy-shortcode', function() {
            var shortcode = $(this).data('shortcode');
            var $btn = $(this);
            
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(shortcode).then(function() {
                    var originalHtml = $btn.html();
                    $btn.html('<span class="dashicons dashicons-yes"></span> Kopyalandı!');
                    setTimeout(function() {
                        $btn.html(originalHtml);
                    }, 2000);
                });
            } else {
                // Fallback for older browsers
                var $temp = $('<input>');
                $('body').append($temp);
                $temp.val(shortcode).select();
                document.execCommand('copy');
                $temp.remove();
                
                var originalHtml = $btn.html();
                $btn.html('<span class="dashicons dashicons-yes"></span> Kopyalandı!');
                setTimeout(function() {
                    $btn.html(originalHtml);
                }, 2000);
            }
        });
        
        // Toggle day active/inactive in settings
        $(document).on('change', '.day-active-checkbox', function() {
            $(this).closest('.day-row').toggleClass('active', $(this).is(':checked'));
        });
    });
    
})(jQuery);
