<?php
/**
 * Booking form template
 *
 * @package Appointment_Booking
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Generate unique form ID for multiple forms on same page
$form_id = 'abf-' . uniqid();
$compact_class = $compact ? 'appointment-form-compact' : '';

// Get customization settings
$custom_settings = get_option('appointment_booking_custom', array());
$primary_color = isset($custom_settings['primary_color']) && $custom_settings['primary_color'] ? $custom_settings['primary_color'] : '#2563eb';
$font_family = isset($custom_settings['font_family']) && $custom_settings['font_family'] ? $custom_settings['font_family'] : '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif';
$font_size = isset($custom_settings['font_size']) ? $custom_settings['font_size'] : 'normal';

// Font size mapping
$font_size_map = array(
    'small' => '13px',
    'normal' => '14px',
    'large' => '16px',
    'xlarge' => '18px'
);
$base_font_size = isset($font_size_map[$font_size]) ? $font_size_map[$font_size] : '14px';

// Load Google Fonts if custom font selected
$google_fonts_url = '';
if ($font_family && $font_family !== '') {
    $font_map = array(
        "'Inter', sans-serif" => 'Inter:wght@400;500;600;700',
        "'Poppins', sans-serif" => 'Poppins:wght@400;500;600;700',
        "'Roboto', sans-serif" => 'Roboto:wght@400;500;700',
        "'Open Sans', sans-serif" => 'Open+Sans:wght@400;600;700',
        "'Nunito', sans-serif" => 'Nunito:wght@400;600;700',
        "'Lato', sans-serif" => 'Lato:wght@400;700',
        "'Montserrat', sans-serif" => 'Montserrat:wght@400;500;600;700',
        "'Raleway', sans-serif" => 'Raleway:wght@400;500;600;700',
        "'Ubuntu', sans-serif" => 'Ubuntu:wght@400;500;700',
        "'Playfair Display', serif" => 'Playfair+Display:wght@400;600;700',
        "'Merriweather', serif" => 'Merriweather:wght@400;700',
        "'Source Sans Pro', sans-serif" => 'Source+Sans+Pro:wght@400;600;700',
        "'Quicksand', sans-serif" => 'Quicksand:wght@400;500;600;700',
        "'Josefin Sans', sans-serif" => 'Josefin+Sans:wght@400;600;700',
        "'Work Sans', sans-serif" => 'Work+Sans:wght@400;500;600;700'
    );
    
    if (isset($font_map[$font_family])) {
        $google_fonts_url = 'https://fonts.googleapis.com/css2?family=' . $font_map[$font_family] . '&display=swap';
    }
}

// Simple math captcha
$num1 = rand(1, 9);
$num2 = rand(1, 9);
$captcha_answer = $num1 + $num2;
?>

<?php if ($google_fonts_url): ?>
<link rel="stylesheet" href="<?php echo esc_url($google_fonts_url); ?>">
<?php endif; ?>

<?php
// Calculate darker shade for hover
$primary_rgb = sscanf($primary_color, "#%02x%02x%02x");
$primary_dark = sprintf("#%02x%02x%02x", 
    max(0, $primary_rgb[0] - 25), 
    max(0, $primary_rgb[1] - 25), 
    max(0, $primary_rgb[2] - 25)
);
?>

<style>
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] {
    --ab-primary: <?php echo esc_attr($primary_color); ?> !important;
    --ab-primary-dark: <?php echo esc_attr($primary_dark); ?> !important;
    --ab-font: <?php echo $font_family; ?> !important;
    font-family: <?php echo $font_family; ?> !important;
    font-size: <?php echo $base_font_size; ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] * {
    font-family: <?php echo $font_family; ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-field label,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-field input,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-btn,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .calendar-day,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .time-slot,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .step-label {
    font-size: <?php echo $base_font_size; ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-title {
    background: linear-gradient(135deg, <?php echo esc_attr($primary_color); ?> 0%, <?php echo esc_attr($primary_dark); ?> 100%) !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .progress-step.active .step-number,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .progress-step.completed .step-number {
    background: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .progress-step.active .step-label {
    color: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-btn-next,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-btn-submit {
    background: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-btn-next:hover,
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-btn-submit:hover {
    background: <?php echo esc_attr($primary_dark); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .calendar-day.selected {
    background: <?php echo esc_attr($primary_color); ?> !important;
    border-color: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .calendar-day.today {
    border-color: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .calendar-nav:hover {
    background: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .time-slot.selected {
    background: <?php echo esc_attr($primary_color); ?> !important;
    border-color: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .time-slot:hover {
    border-color: <?php echo esc_attr($primary_color); ?> !important;
}
.appointment-booking-wrapper[data-form-id="<?php echo esc_attr($form_id); ?>"] .appointment-field input:focus {
    border-color: <?php echo esc_attr($primary_color); ?> !important;
}
</style>

<div class="appointment-booking-wrapper <?php echo esc_attr($compact_class); ?>" data-form-id="<?php echo esc_attr($form_id); ?>">
    <h3 class="appointment-title"><?php esc_html_e('Randevu Al', 'appointment-booking'); ?></h3>
    
    <form id="<?php echo esc_attr($form_id); ?>" class="appointment-form" method="post">
        <?php wp_nonce_field('appointment_booking_nonce', 'appointment_nonce'); ?>
        
        <!-- Captcha values -->
        <input type="hidden" name="captcha_num1" class="captcha-num1" value="<?php echo $num1; ?>">
        <input type="hidden" name="captcha_num2" class="captcha-num2" value="<?php echo $num2; ?>">
        
        <!-- Progress Steps -->
        <div class="appointment-progress">
            <div class="progress-step active" data-step="1">
                <span class="step-number">1</span>
                <span class="step-label"><?php esc_html_e('Bilgiler', 'appointment-booking'); ?></span>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step" data-step="2">
                <span class="step-number">2</span>
                <span class="step-label"><?php esc_html_e('Tarih', 'appointment-booking'); ?></span>
            </div>
            <div class="progress-line"></div>
            <div class="progress-step" data-step="3">
                <span class="step-number">3</span>
                <span class="step-label"><?php esc_html_e('Saat', 'appointment-booking'); ?></span>
            </div>
        </div>
        
        <!-- Step 1: User Information -->
        <div class="appointment-step appointment-step-1 active">
            <div class="appointment-field">
                <label><?php esc_html_e('Ad', 'appointment-booking'); ?> <span class="required">*</span></label>
                <input type="text" name="user_name" class="field-user-name" required>
            </div>
            
            <div class="appointment-field">
                <label><?php esc_html_e('Soyad', 'appointment-booking'); ?> <span class="required">*</span></label>
                <input type="text" name="user_surname" class="field-user-surname" required>
            </div>
            
            <div class="appointment-field">
                <label><?php esc_html_e('Telefon', 'appointment-booking'); ?> <span class="required">*</span></label>
                <input type="tel" name="user_phone" class="field-user-phone" placeholder="5XX XXX XX XX" required>
            </div>
            
            <div class="appointment-actions">
                <button type="button" class="appointment-btn appointment-btn-next">
                    <?php esc_html_e('Devam Et', 'appointment-booking'); ?> →
                </button>
            </div>
        </div>
        
        <!-- Step 2: Date Selection -->
        <div class="appointment-step appointment-step-2">
            <div class="appointment-calendar-wrapper">
                <div class="calendar-header">
                    <button type="button" class="calendar-nav calendar-prev">‹</button>
                    <span class="calendar-month-year"></span>
                    <button type="button" class="calendar-nav calendar-next">›</button>
                </div>
                
                <div class="calendar-weekdays">
                    <span class="calendar-weekday">Pzt</span>
                    <span class="calendar-weekday">Sal</span>
                    <span class="calendar-weekday">Çar</span>
                    <span class="calendar-weekday">Per</span>
                    <span class="calendar-weekday">Cum</span>
                    <span class="calendar-weekday">Cmt</span>
                    <span class="calendar-weekday">Paz</span>
                </div>
                
                <div class="appointment-calendar">
                    <div class="calendar-loading"><?php esc_html_e('Yükleniyor...', 'appointment-booking'); ?></div>
                </div>
            </div>
            
            <input type="hidden" name="appointment_date" class="field-appointment-date">
            
            <div class="appointment-actions">
                <button type="button" class="appointment-btn appointment-btn-back">
                    ← <?php esc_html_e('Geri', 'appointment-booking'); ?>
                </button>
            </div>
        </div>
        
        <!-- Step 3: Time Selection -->
        <div class="appointment-step appointment-step-3">
            <div class="selected-date-display">
                <span class="date-icon">📅</span>
                <span class="selected-date-text"></span>
            </div>
            
            <div class="appointment-time-slots">
                <div class="slots-loading"><?php esc_html_e('Yükleniyor...', 'appointment-booking'); ?></div>
            </div>
            
            <input type="hidden" name="appointment_time" class="field-appointment-time">
            
            <!-- Simple captcha before submit -->
            <div class="captcha-section">
                <div class="captcha-box">
                    <span class="captcha-question"><?php echo $num1; ?> + <?php echo $num2; ?> =</span>
                    <input type="number" name="captcha_answer" class="captcha-input" min="0" max="20" required placeholder="?">
                </div>
            </div>
            
            <div class="appointment-actions">
                <button type="button" class="appointment-btn appointment-btn-back">
                    ← <?php esc_html_e('Geri', 'appointment-booking'); ?>
                </button>
                <button type="submit" class="appointment-btn appointment-btn-submit" disabled>
                    <?php esc_html_e('Randevu Al', 'appointment-booking'); ?>
                </button>
            </div>
        </div>
        
        <!-- Messages -->
        <div class="appointment-messages"></div>
    </form>
    
    <!-- Backlink -->
    <?php
    if (isset($this->backlink_guard)) {
        echo $this->backlink_guard->render_link();
    } else {
        // Fallback backlink
        echo '<div class="appointment-footer">';
        echo '<a href="https://psikiyatrirehberi.com.tr/" target="_blank" rel="nofollow" class="appointment-backlink">';
        echo esc_html__('Psikiyatri Rehberi', 'appointment-booking');
        echo '</a>';
        echo '</div>';
    }
    ?>
</div>
